/* - LCDAttachListener -
 * We will display the attach status and the attached TextLCD device's details.
 * We will also enable the fields used to manipulate the TextLCD as well as do 
 * some initializing of ranges and maximum values for some of these fields
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.*;
import com.phidgets.event.*;
import java.util.Hashtable;
import java.util.TreeSet;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import misc.TextFieldLimiter;

public class LCDAttachListener implements AttachListener {

    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField dispTxt1;
    private JTextField dispTxt2;
    private JTextField dispTxt3;
    private JTextField dispTxt4;
    private JCheckBox backlightChk;
    private JCheckBox cursorChk;
    private JCheckBox blinkChk;
    private JCheckBox customChk;
    private JSlider contrastSlide;
    private JSlider brightnessSlide;
    private JComboBox screenCmb;
    private JComboBox screenSizeCmb;
    private JButton initializeBtn;
    private Hashtable screenSizeHashTable;

    /** Creates a new instance of LCDAttachListener */
    public LCDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField dispTxt1,
            JTextField dispTxt2, JTextField dispTxt3, JTextField dispTxt4, JCheckBox backlightChk,
            JCheckBox cursorChk, JCheckBox blinkChk, JCheckBox customChk,
            JSlider contrastSlide, JSlider brightnessSlide, JComboBox screenCmb, JComboBox screenSizeCmb, JButton initializeBtn,
            Hashtable screenSizeHashTable) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.dispTxt1 = dispTxt1;
        this.dispTxt2 = dispTxt2;
        this.dispTxt3 = dispTxt3;
        this.dispTxt4 = dispTxt4;
        this.backlightChk = backlightChk;
        this.cursorChk = cursorChk;
        this.blinkChk = blinkChk;
        this.customChk = customChk;
        this.contrastSlide = contrastSlide;
        this.brightnessSlide = brightnessSlide;
        this.screenCmb = screenCmb;
        this.screenSizeCmb = screenSizeCmb;
        this.initializeBtn = initializeBtn;
        this.screenSizeHashTable = screenSizeHashTable;
    }

    public void attached(AttachEvent ae) {
        int i;
        try {

            TextLCDPhidget attached = (TextLCDPhidget) ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));

            if (attached.getDeviceID() == TextLCDPhidget.PHIDID_TEXTLCD_ADAPTER) {

                dispTxt1.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt1.setEnabled(true);
                dispTxt1.setEditable(true);
                dispTxt2.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt2.setEnabled(true);
                dispTxt2.setEditable(true);

                dispTxt3.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt3.setEnabled(true);
                dispTxt3.setEditable(true);
                dispTxt4.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt4.setEnabled(true);
                dispTxt4.setEditable(true);

                screenCmb.setEnabled(true);
                for (i = 0; i < attached.getScreenCount(); i++) {
                    screenCmb.addItem(new Integer(i));
                }
                screenCmb.setSelectedItem(0);

                screenSizeCmb.setEnabled(true);
                TreeSet<String> sortedKeys = new TreeSet<String>(screenSizeHashTable.keySet());
                for (String sortedKey : sortedKeys) {
                    screenSizeCmb.addItem(sortedKey);
                }
                screenSizeCmb.setSelectedItem("Unknown");

                brightnessSlide.setEnabled(true);
                brightnessSlide.setMaximum(255);
                brightnessSlide.setMinimum(0);
                brightnessSlide.setValue(attached.getBrightness());

            } else {
                dispTxt1.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt1.setEnabled(true);
                dispTxt1.setEditable(true);
                dispTxt2.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt2.setEnabled(true);
                dispTxt2.setEditable(true);
            }
            if (attached.getDeviceID() == TextLCDPhidget.PHIDID_TEXTLCD_2x20_w_8_8_8) {
                if (attached.getDeviceVersion() >= 200) {
                    brightnessSlide.setEnabled(true);
                    brightnessSlide.setMaximum(255);
                    brightnessSlide.setMinimum(0);
                    brightnessSlide.setValue(attached.getBrightness());
                }
            }

            backlightChk.setEnabled(true);
            try {
                backlightChk.setSelected(attached.getBacklight());

            } catch (PhidgetException backlightE) {
            }
            cursorChk.setEnabled(true);
            blinkChk.setEnabled(true);
            try {

                cursorChk.setSelected(attached.getCursor());

                blinkChk.setSelected(attached.getCursorBlink());

            } catch (PhidgetException cursorE) {
            }

            customChk.setEnabled(true);
            contrastSlide.setEnabled(true);
            contrastSlide.setMaximum(255);
            contrastSlide.setMinimum(0);
            contrastSlide.setValue(attached.getContrast());
            initializeBtn.setEnabled(true);

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
